﻿# Nazwa instancji serwera
$ServerInstance = "SharePoint\PowerPivot"

# Ładuje złożenie SMO SQL
[void][System.Reflection.Assembly]::LoadWithPartialName('Microsoft.SqlServer.SMO')
# Tworzy obiekt SMO instancji SQL Server
$Server = new-object ('Microsoft.SqlServer.Management.Smo.Server') $ServerInstance 

Write-Host "$ServerInstance Server Instance Properties" -ForegroundColor Red 
Write-Host "=============================================== `r" -ForegroundColor DarkRed

# Pobiera własności serwera
$Server.Properties | Select Name, Value 

Write-Host "====================================" -ForegroundColor Red

# Oteruje przez listę baz danych na instancji serwera
ForEach($Database in $Server.Databases)
{
    Write-Host $Database.Name " Własności bazy danych" -ForegroundColor Green 
    Write-Host "===============================================" -ForegroundColor DarkGreen
    
    # Pobiera własności bazy danych
    $Database.Properties | Select Name, Value
    Write-Host "===============================================" -ForegroundColor DarkGreen
    "`r"
} 